﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;

namespace NVCC.Models
{
    [Serializable]
    public class Disclosure
    {
        //If there is ever a time when they want to add another option other than "Referral for Care", then, at that time,
        //we can add another column in the Disclosure table and make the default value "Referral for Care" and change the model accordingly
        private const string _statementOfPurpose = "Referral for Care";
        public int DisclosureId { get; set; }
        public string UserId { get; set; }
        public string PatientIcn { get; set; }
        public DateTime DateTimeOfDisclosure { get; set; }
        public string StatementOfPurpose { get { return _statementOfPurpose; } }

        
        [StringLength(50, ErrorMessage = "Provider Name/Group cannot be longer than 50 characters.")]
        [Display(Name = "Provider Name or Group")]
        public string ProviderNameOrGroup { get; set; }

        [Display(Name = "Street Address 1")]
        [StringLength(50, ErrorMessage = "The street address cannot be longer than 50 characters.")]
        public string ProviderStreetAddress1 { get; set; }

        [Display(Name = "Street Address 2")]
        [StringLength(50, ErrorMessage = "The street address cannot be longer than 50 characters.")]
        public string ProviderStreetAddress2 { get; set; }
        
        [StringLength(50, ErrorMessage = "City cannot be longer than 50 characters")]
        [Display(Name = "City")]
        [RegularExpression("(^[a-zA-Z '-]+$)", ErrorMessage = "Only letters, spaces, apostrophes and hyphens are allowed in a city name.")]
        public string ProviderCity { get; set; }

        [Display(Name = "State")]
        public string ProviderState { get; set; }
        
        [RegularExpression("(^\\d{5}(?:[-]\\d{4})?$)", ErrorMessage = "ZIP Code must be either a 5 digit zip code or zip plus 4 format (i.e. xxxxx-xxxx)")]
        [StringLength(10, ErrorMessage = "ZIP Code cannot be longer than 10 characters")]
        [Display(Name = "Zip")]
        public string ProviderZip { get; set; }

        [StringLength(15, MinimumLength = 10, ErrorMessage = "Phone number cannot be longer than 15 characters or less than 10.")]
        [RegularExpression("(^(?=.*[0-9])[-0-9]+$)", ErrorMessage = "Phone number can only contain numbers and hyphens/dashes.")]
        [Display(Name = "Phone")]
        public string ProviderPhone { get; set; }

        public string ReferralType { get; set; }

        public short Sta3n { get; set; }
        public short? VISN { get; set; }
        public string StationName { get; set; }

        public virtual ICollection<Nature> Natures { get; set; }
        public virtual IList<AdditionalObject> AdditionalObjects { get; set; }
        public virtual ICollection<DisclosedAppointment> DisclosedAppointments { get; set; }
        public virtual ICollection<DisclosedAuthorization> DisclosedAuthorizations { get; set; }
        public virtual ICollection<DisclosedProblemDiagnosis> DisclosedProblemDiagnoses { get; set; }
        public virtual ICollection<DisclosedProgressNote> DisclosedProgressNotes { get; set; }
        public virtual ICollection<DisclosedRadiologyReport> DisclosedRadiologyReports { get; set; }
        public virtual ICollection<DisclosedConsult> DisclosedConsults { get; set; }
        public virtual ICollection<DisclosedVistAImagingStudy> DisclosedVistAImagingStudies { get; set; }

        //As far as I can tell, a user really can only select one Authorization and one Consult, so, for simplicity, adding this:
        public DisclosedAuthorization DisclosedAuthorization
        {
            get
            {
                if (DisclosedAuthorizations != null && DisclosedAuthorizations.Any())
                {
                    return DisclosedAuthorizations.FirstOrDefault();
                }
                else
                {
                    return null;
                }
            }
        }
        public DisclosedConsult DisclosedConsult
        {
            get
            {
                if (DisclosedConsults != null && DisclosedConsults.Any())
                {
                    return DisclosedConsults.FirstOrDefault();
                }
                else
                {
                    return null;
                }
            }
        }
    }
}
